/*
  Kapazitätsmeter

  Misst bis zu zwei Kapazitäten über die Ladezeit im Pikometerbereich. 

  created 2020
  by Marco Janßen 
*/



/*---Variablen-und-Konstanten-----------------------------------------*/

#define buttonPin A5
#define ledPin 13
#define gndPin A2
#define analogPinA A0
#define chargePinA A1
#define analogPinB A4
#define chargePinB A3

#define VPin 2


#define resistorValueA  9.80F  //in MOhm
#define resistorValueB  9.80F  //in MOhm

#define rangeData 2   //Bestimmt die Trägheit mit der sich die Messwerte ändern. Kleine Schwankungen können so abgefankgen werden.
#define RC_A 647      //Entspricht 63.2% der Spannung bei maximaler Ladung. Diese Spannung wird nach R·C Sekunden erreicht.  Theoretisch: 647
#define RC_B 647 
String unitA = "Kapazitaet in muC";
String unitB = "Kapazitaet in muC";

 
float C_0_A = 0;      //Entspricht der Kapazität der Schaltung ohne die zu messende Kapazität. Diese ist parallel zur unbekannten Kapazität geschaltet und kann daher vom Endergebnis abgezogen werden.
float C_0_B = 0;

int timeA = 0;
int timeB = 0;


float dataA[rangeData];
float dataB[rangeData];

float averageDataA = 0;
float averageDataB = 0;



/*---Messprinzip------------------------------------------------------*/

float meassureC(uint8_t analogPin, uint8_t chargePin, int RC = RC_A, uint8_t samples = 5){ 
  unsigned long tau = 0;
  unsigned long startTime;

  pinMode(analogPin, INPUT);
  digitalWrite(analogPin, LOW);
  pinMode(chargePin, OUTPUT);
       
  for(int k = 0; k < samples; k++){  
    digitalWrite(chargePin, LOW); 
 
    while(analogRead(analogPin) > 0){        
    }
   
//Problem: Der Kondensator ist jetzt nicht komplett entladen. Eine mögliche Lösung:
    pinMode(analogPin, OUTPUT);
    delay(1);
    pinMode(analogPin, INPUT);

    digitalWrite(chargePin, HIGH);            
    startTime = micros();                                       
    while(analogRead(analogPin) < RC){          
    }
    tau += micros() - startTime; 
  }                        
  return (float)(tau / samples); 
}


/*---Berechnung-des-Durchschnitts---------------------------------------*/

float getAverage(float *arr, int size) {
   long  i, sum = 0;       
   float avg;          
 
   for (i = 0; i < size; i++) {
      sum += arr[i];
   }
 
   avg = (float)sum / size;
   return avg;
}


/*---Outputs----------------------------------------------------------*/

#include <SoftModem.h>
SoftModem modem = SoftModem();


void audioPlotter(float t1_plotter = 0, float m1_plotter = 0, float t2_plotter = 0, float m2_plotter = 0){
  m1_plotter += 0.25;
  m1_plotter = (int)(m1_plotter * 2);
  m1_plotter /= 2;
  
  m2_plotter += 0.25;
  m2_plotter = (int)(m2_plotter * 2);
  m2_plotter /= 2;
  
  modem.print(String(round(t2_plotter - t1_plotter)) + ";" + String(m1_plotter) + ";" + String(m2_plotter));
} 


void sendUnits() {
  delay(100);
  modem.print("units;" + unitA + ";" + unitB);
}


/*---Definitionen-für-das-schnellen-ADC-------------------------------*/

#define FASTADC 1      // 0 enspricht normaler Abtastrate, 1 entspricht erhöhung der Abtastrate
/*
With FASTADC defined as 1, the 1000 calls to analogRead() take 16 msec (16 microseconds per call). 
With FASTADC defined as 0, the default prescale gives 111 microseconds per call.
*/

// defines for setting and clearing register bits
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif


/*---EEPROM-----------------------------------------------------------*/

#include <EEPROM.h>

void WriteEEPROM (int pos, float wert){
  const byte* p = (const byte*)(const void*)&wert;
  unsigned int i;
  for (int i = 0; i < 4; i++)
    EEPROM.write(pos++, *p++);
}

float ReadEEPROM (int pos){
  float wert;
  byte* p = (byte*)(void*)&wert;
  unsigned int i;
  for (i = 0; i < 4; i++) 
    *p++ = EEPROM.read(pos++);
  return wert;
}


/*---Hauptprogrammteil------------------------------------------------*/

void setup(){  
    #if FASTADC
//  // set prescale to 32
//  sbi(ADCSRA,ADPS2) ;
//  cbi(ADCSRA,ADPS1) ;
//  sbi(ADCSRA,ADPS0) ;

// set prescale to 16 : Verlust der Genauigkeit ist mit dieser Samplerate für diese Anwendung nicht messbar -> perfekt!
  sbi(ADCSRA,ADPS2) ;
  cbi(ADCSRA,ADPS1) ;
  cbi(ADCSRA,ADPS0) ;
  
//  // set prescale to 8
//  cbi(ADCSRA,ADPS2) ;
//  sbi(ADCSRA,ADPS1) ;
//  sbi(ADCSRA,ADPS0) ;
  #endif
 

  modem.begin();
  sendUnits();

  
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin, LOW);
  pinMode(gndPin, OUTPUT);
  digitalWrite(gndPin, LOW);

  pinMode(VPin, OUTPUT);
  digitalWrite(VPin, HIGH);

  C_0_A = ReadEEPROM(4);
  C_0_B = ReadEEPROM(8);
  
  for(int i = 0; i < rangeData; i++){
    dataA[i] = C_0_A;
    dataB[i] = C_0_B;
  }
}


void loop() {
  for(int i = rangeData - 1; i > 0; i--){
    dataA[i]=dataA[i-1];
    dataB[i]=dataB[i-1];
  }
  
  if(digitalRead(buttonPin) == HIGH){
    dataA[0] = meassureC(analogPinA, chargePinA, RC_A, 5);
    timeA = millis();
    dataB[0] = meassureC(analogPinB, chargePinB, RC_B, 5);
    timeB = millis();
 
    averageDataA = getAverage(dataA, rangeData);
    averageDataB = getAverage(dataB, rangeData);

    float C_A = averageDataA / resistorValueA  - (float)C_0_A;
    float C_B = averageDataB / resistorValueB  - (float)C_0_B;
    
    audioPlotter(timeA, C_A, timeB, C_B);
  } 
  else{
    digitalWrite(ledPin, HIGH);
    delay(1000);
    
    C_0_A = meassureC(analogPinA, chargePinA, RC_A, 50) / resistorValueA;
    WriteEEPROM(4, C_0_A);
    
    C_0_B = meassureC(analogPinB, chargePinB, RC_B, 50) / resistorValueB;
    WriteEEPROM(8, C_0_B);

    sendUnits();
    
    digitalWrite(ledPin, LOW);
  }
}
